Attribute VB_Name = "modBotFunctions"
Option Explicit

'BNLS Product  codes
Public Const PRODUCT_STAR As Byte = &H1
Public Const PRODUCT_SEXP As Byte = &H2
Public Const PRODUCT_W2BN As Byte = &H3
Public Const PRODUCT_D2DV As Byte = &H4
Public Const PRODUCT_D2XP As Byte = &H5
Public Const PRODUCT_WAR3 As Byte = &H7
Public Const PRODUCT_W3XP As Byte = &H8

Public Const PRODUCT_CHAT As Byte = &H9 'Non-BNLS Supported Product

Public Function setProductInformation(ByVal Index As Integer)
    Select Case Bots(Index).Product
        Case "STAR", "RATS"
            With Bots(Index)
                .Product = "RATS"
                .Client = PRODUCT_STAR
                .VerByte = VerByte.STAR
            End With
            HashDir(0) = G_Settings.STAR_HASH_PATH & "\Starcraft.exe"
            HashDir(1) = G_Settings.STAR_HASH_PATH & "\storm.dll"
            HashDir(2) = G_Settings.STAR_HASH_PATH & "\battle.snp"
        Case "SEXP", "PXES"
            With Bots(Index)
                .Product = "PXES"
                .Client = PRODUCT_SEXP
                .VerByte = VerByte.SEXP
            End With
            HashDir(0) = G_Settings.STAR_HASH_PATH & "\Starcraft.exe"
            HashDir(1) = G_Settings.STAR_HASH_PATH & "\storm.dll"
            HashDir(2) = G_Settings.STAR_HASH_PATH & "\battle.snp"
        Case "W2BN", "NB2W"
            With Bots(Index)
                .Product = "NB2W"
                .Client = PRODUCT_W2BN
                .VerByte = VerByte.W2BN
            End With
            HashDir(0) = G_Settings.W2BN_HASH_PATH & "\Warcraft II BNE.exe"
            HashDir(1) = G_Settings.W2BN_HASH_PATH & "\storm.dll"
            HashDir(2) = G_Settings.W2BN_HASH_PATH & "\battle.snp"
        Case "WAR3", "3RAW"
            With Bots(Index)
                .Product = "3RAW"
                .Client = PRODUCT_WAR3
                .VerByte = VerByte.WAR3
            End With
            HashDir(0) = G_Settings.WAR3_HASH_PATH & "\war3.exe"
            HashDir(1) = G_Settings.WAR3_HASH_PATH & "\storm.dll"
            HashDir(2) = G_Settings.WAR3_HASH_PATH & "\game.dll"
        Case "W3XP", "PX3W"
            With Bots(Index)
                .Product = "PX3W"
                .Client = PRODUCT_W3XP
                .VerByte = VerByte.W3XP
            End With
            HashDir(0) = G_Settings.WAR3_HASH_PATH & "\war3.exe"
            HashDir(1) = G_Settings.WAR3_HASH_PATH & "\storm.dll"
            HashDir(2) = G_Settings.WAR3_HASH_PATH & "\game.dll"
        Case "D2DV", "VD2D"
            With Bots(Index)
                .Product = "VD2D"
                .Client = PRODUCT_D2DV
                .VerByte = VerByte.D2DV
            End With
            HashDir(0) = G_Settings.D2DV_HASH_PATH & "\Game.exe"
            HashDir(1) = G_Settings.D2DV_HASH_PATH & "\bnclient.dll"
            HashDir(2) = G_Settings.D2DV_HASH_PATH & "\d2client.dll"
        Case "D2XP", "PX2D"
            With Bots(Index)
                .Product = "PX2D"
                .Client = PRODUCT_D2XP
                .VerByte = VerByte.D2XP
            End With
            HashDir(0) = G_Settings.D2XP_HASH_PATH & "\Game.exe"
            HashDir(1) = G_Settings.D2XP_HASH_PATH & "\bnclient.dll"
            HashDir(2) = G_Settings.D2XP_HASH_PATH & "\d2client.dll"
        Case "CHAT", "TAHC"
            With Bots(Index)
                .Product = "TAHC"
                .Client = PRODUCT_CHAT
            End With
        
        Case Else
            
    End Select
End Function

Private Function validateBotForConnecting(ByRef Index As Integer) As Boolean
    validateBotForConnecting = True
    If (Bots(Index).Username = vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a username (Profile: " & Bots(Index).Profile & ")"
        validateBotForConnecting = False
    End If
    If (Bots(Index).Product = vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a product (Profile: " & Bots(Index).Profile & ")"
        validateBotForConnecting = False
    End If
    'Shouldn't NEED a version byte if your connecting to BNLS because of REQUEST_VERSIONBYTE.
    If (Bots(Index).Connection <> 2) Then
        If (Bots(Index).VerByte = 0) Then
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a version byte (Profile: " & Bots(Index).Profile & ")"
            validateBotForConnecting = False
        End If
    End If
    If (Bots(Index).P_CDKey = vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a cdkey (Profile: " & Bots(Index).Profile & ")"
        validateBotForConnecting = False
    End If
    If (Bots(Index).Password = vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a password (Profile: " & Bots(Index).Profile & ")"
        validateBotForConnecting = False
    End If
    If (Bots(Index).Home = vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Please specify a home channel (Profile: " & Bots(Index).Profile & ")"
        validateBotForConnecting = False
    End If
End Function

Public Function connectBot(ByVal Index As Integer)
    Dim serverIP As String, serverPort As Integer
    
    Debug.Print "Connect Index: " & Index
    
    'Set the auto reconnect boolean false
    Bots(Index).ConnectionKilled = False
    
    Call setProductInformation(Index)

    If (Bots(Index).Connected) Then frmMain.sckBNET(Index).Close
    
    If (validateBotForConnecting(Index) = True) Then
        Select Case Bots(Index).Connection
            Case 1 'BNCS
                If (InStr(Bots(Index).Server, ":")) Then
                    serverIP = Split(Bots(Index).Server, ":")(0)
                    serverPort = serverIP = Split(Bots(Index).Server, ":")(1)
                Else
                    serverIP = Bots(Index).Server
                End If
                If serverPort = 0 Then serverPort = 6112
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNET & "Connecting to " & serverIP & ":" & serverPort
                frmMain.sckBNET(Index).Connect serverIP, serverPort
                
            Case 2 'BNLS
                G_Settings.BNLS_Server = "bnls.valhallalegends.com"
                If (InStr(G_Settings.BNLS_Server, ":")) Then
                    serverIP = Split(G_Settings.BNLS_Server, ":")(0)
                    serverPort = serverIP = Split(G_Settings.BNLS_Server, ":")(1)
                Else
                    serverIP = G_Settings.BNLS_Server
                End If
                If serverPort = 0 Then serverPort = 9367
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNLS & "Connecting to " & serverIP & ":" & serverPort
                frmMain.sckBNLS(Index).Connect serverIP, serverPort
                
            Case Else
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Error: Could not identify which connection to use."
        End Select
    End If
    
    If (G_Options.Debug_Mode) Then
        Debug.Print "Username -> " & Bots(BotIndex).Username
        Debug.Print "Password -> " & Bots(BotIndex).Password
        Debug.Print "CDKey    -> " & Bots(BotIndex).P_CDKey
        Debug.Print "Product  -> " & Bots(BotIndex).Product
        Debug.Print "VerByte  -> 0x" & Hex(Bots(BotIndex).VerByte)
        Debug.Print vbCrLf
    End If
End Function

Public Function closeBot(ByVal Index As Integer)
    With frmMain
        If (.sckBNET(Index).State = sckConnected) Then
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Connection: Closed."
        End If
        .sckBNET(Index).Close
        .sckBNLS(Index).Close
        .sckREALM(Index).Close
        
        If (BotIndex = Index) Then
            'Clear listviews
            .lvUsers.ListItems.Clear
            .lvClan.ListItems.Clear
            .lvFriends.ListItems.Clear
            
            'Set channel label
            .lblChannel.Caption = "Disconnected (0)"
        End If
    End With
    Bots(Index).Connected = False
    
    Call ProfileHandler(Index).UserListing.Reset(CHANNEL_USER)
    Call ProfileHandler(Index).UserListing.Reset(CLAN_USER)
    Call ProfileHandler(Index).UserListing.Reset(FRIEND_USER)
    
    Call updateBotChannel(Index, vbNullString)
    
End Function

Public Sub initiateAutoReconnectProcedure(ByRef Index As Integer)
    If (G_Options.Auto_Reconnect) Then
        'Auto reconnect procedure
        Bots(Index).ConnectionKilled = True
        Call timerAutoReconnect
    End If
End Sub


Public Function updateBotChannel(ByVal Index As Integer, ByVal Channel As String)
    Bots(Index).CurrentChannel = Channel
    
    
    If (Bots(Index).Connected = True) Then
        frmMain.mnuBot(Index).Caption = Bots(Index).Profile & " => " & Bots(Index).CurrentChannel
        If (BotIndex = Index) Then
            frmMain.lblChannel.Caption = Bots(Index).CurrentChannel & " (" & frmMain.lvUsers.ListItems.Count & ")"
        End If
    ElseIf (Bots(Index).CurrentChannel = vbNullString And Bots(Index).Connected = True) Then
        frmMain.mnuBot(Index).Caption = Bots(Index).Profile & " => Connected"
        If (BotIndex = Index) Then
            frmMain.lblChannel.Caption = "Connected (0)"
        End If
    Else
        frmMain.mnuBot(Index).Caption = Bots(Index).Profile & " => Disconnected"
        If (BotIndex = Index) Then
            frmMain.lblChannel.Caption = "Disconnected (0)"
        End If
    End If
End Function

Public Function AddQueue(ByVal Index As Integer, ByVal Message As String, Optional ByVal Priority As Byte = 0)
    Call ValidateCHATCOMMAND(Index, Message) 'Does function to the message to alter it just in case before sending it to battle.net
    
    'This currently uses 3 levels of priority, the queue class can support an infinite amount however.
    If (InStr(Message, Space(1))) Then
        Select Case LCase$((Split(Message, Space(1))(0)))
            Case "/join", "/j", "/channel": Priority = 1
            Case "/ban": Priority = 1
            Case "/ignore", "/squlech": Priority = 1
            Case "/time": Priority = 3
            Case "/unban": Priority = 2
            Case "/w", "/whisper": Priority = 2
            Case "/f m", "/f message": Priority = 2
            Case "/f list", "/f l": Priority = 3
            Case "/f add", "/f a": Priority = 3
            Case "/f remove", "/f r": Priority = 3
            Case "/help": Priority = 3
            Case Else: Priority = 0
        End Select
    End If
    Call ProfileHandler(Index).Queue.AddQueue(Message, Priority)
End Function

Private Sub ValidateCHATCOMMAND(ByVal Index As Integer, ByRef strMessage As String)
    Dim Splt() As String
        
    'If the client is D2DV/D2XP then add in asteriks if not added already.
    If ((Bots(Index).Client = PRODUCT_D2DV) Or (Bots(Index).Client) = PRODUCT_D2XP) Then
        Splt() = Split(strMessage, Space(1), 2)
        If UBound(Splt) > 0 Then
            If LCase(Splt(0)) = "/w" Or LCase(Splt(0)) = "/ban" Or LCase(Splt(0)) = "/unignore" Or LCase(Splt(0)) = "/ignore" Or LCase(Splt(0)) = "/msg" Or LCase(Splt(0)) = "/m" Or LCase(Splt(0)) = "/message" Or LCase(Splt(0)) = "/whisper" Or LCase(Splt(0)) = "/kick" Or LCase(Splt(0)) = "/unban" Or LCase(Splt(0)) = "/designate" Then
                If Left$(Splt(1), 1) <> "*" Then
                    strMessage = Splt(0) & Space(1) & "*" & Splt(1)
                End If
            End If
        End If
    End If
    
    strMessage = Left$(strMessage, 230)
End Sub
